/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import java.awt.Component;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;

public class VWAccessibilityHelper {
    public static void setAccessibility(Component comp, Accessible parent, String name, String descrip) {
        AccessibleContext context;
        if (comp != null && (context = comp.getAccessibleContext()) != null) {
            if (parent != null) {
                context.setAccessibleParent(parent);
            }
            if (name != null) {
                context.setAccessibleName(name);
            }
            if (descrip != null) {
                context.setAccessibleDescription(descrip);
            }
        }
    }

    public static void setLabelFor(JLabel label, Component comp) {
        AccessibleRelationSet arSet = label.getAccessibleContext().getAccessibleRelationSet();
        AccessibleRelation ar = new AccessibleRelation(AccessibleRelation.LABEL_FOR, comp);
        arSet.add(ar);
        arSet = comp.getAccessibleContext().getAccessibleRelationSet();
        ar = new AccessibleRelation(AccessibleRelation.LABELED_BY, label);
        arSet.add(ar);
    }

    public static void setMemberOf(AbstractButton button, ButtonGroup buttonGroup) {
        AccessibleContext accessible_context = button.getAccessibleContext();
        AccessibleRelationSet relationSet = accessible_context.getAccessibleRelationSet();
        AccessibleRelation grouped = new AccessibleRelation(AccessibleRelation.MEMBER_OF, buttonGroup);
        relationSet.add(grouped);
        buttonGroup.add(button);
    }
}

